/****************************************************************************************
* Copyright (C) 2019 - 2020 Intel Corporation
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice,
*    this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 3. Neither the name of the copyright holder nor the names of its contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
* THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
* OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* SPDX-License-Identifier: BSD-3-Clause
*
****************************************************************************************/

#ifndef _DEF_DDP_H_
#define _DEF_DDP_H_

#include <stdint.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <getopt.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>

#define upper_32_bits(x)    ((u32)((((x) >> 16) >> 16) & 0xFFFFFFFF))
#define lower_32_bits(x)    ((u32)((x) & 0xFFFFFFFF))

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/pci.h>

#include "ddp_types.h"
#include "ddp_status.h"
#include "ddp_list.h"
#include "output.h"
#include "os.h"

#include <unistd.h>

#define PATH_TO_SYSFS_PCI "/sys/bus/pci/devices/"

#define ETHTOOL_GDRVINFO 0x00000003
#define ETHTOOL_IOCTL    0x8946

#define ADMINQ_COMMAND_GET_FW_VERSION       0x0001
#define ADMINQ_COMMAND_GET_DDP_PROFILE_LIST 0x0271

#define ADMINQ_FLAG_BUF                     0x1000 /* no additional buffer */
#define ADMINQ_FLAG_SI                      0x2000 /* do not interupt when this commands completes */

#define BASEDRIVER_GET_DRIVER_INFO          3
#define BASEDRIVER_READNVM_FUNCID           11
#define BASEDRIVER_WRITENVM_FUNCID          12

#define DDP_DECIMAL_SYSTEM                  10
#define DDP_HEXADECIMAL_SYSTEM              16

#define PCI_LOCATION_STRING_SIZE            12

#define MEMINIT(x) memset(x, 0, sizeof(*x))

typedef struct ifreq ifreq_t;

#define MAX_DRIVER_VERSION_STRING_LENTGH  32
#define NUMBER_OF_DRIVER_VERSION_PARTS    3
#define LINUX_40G_VIRTUAL_DEVID           0x154C
#define BARLEYVILLE_40G_VIRTUAL_DEVID     0xFBFB

#define PCI_DEVICE_CONFIG_DWORDS          16

/* Admin Queue defaults */
#define I40E_DEFAULT_DESCRIPTORS          32
#define I40E_ADMINQ_DEFAULT_BUFFER_SIZE   8

#define MIN_FW_VERSION_MAJOR              6
#define MIN_FW_VERSION_MINOR              1
#define NUMBER_OF_PROFILES_LENGTH         4
#define OFFSET_TO_ADMINQ_WRITEBACK        16
#define OFFSET_TO_PROFILE_LIST_SIZE       16
#define DDP_ADMINQ_WRITEBACK_SIZE         0x500
#define IOCTL_EXECUTE_COMMAND             0xF << 8

#define DDP_MAJOR_VERSION                   1
#define DDP_MINOR_VERSION                   0
#define DDP_BUILD_VERSION                   0
#define DDP_FIX_VERSION                     8

#define DDP_MIN_BASE_DRIVER_VERSION_MAJOR 2
#define DDP_MIN_BASE_DRIVER_VERSION_MINOR 7
#define DDP_MIN_BASE_DRIVER_VERSION_BUILD 27

#define MAX_FILE_NAME                     300

#define DDP_LOCATION_COMMAND_PARAMETER    's'
#define DDP_HELP1_COMMAND_PARAMETER       'h'
#define DDP_HELP2_COMMAND_PARAMETER       '?'
#define DDP_INTERFACE_COMMAND_PARAMETER   'i'
#define DDP_XML_COMMAND_PARAMETER         'x'
#define DDP_VERSION_COMMAND_PARAMETER     'v'
#define DDP_SILENT_MODE                   'l'
#define DDP_JSON_COMMAND_PARAMETER        'j'
#define DDP_ALL_ADAPTERS_PARAMETER        'a'

#define DDP_LOCATION_COMMAND_PARAMETER_BIT  (1 << 0)  /* '-s' - location command line parameter */
#define DDP_ALL_ADAPTERS_PARAMETER_BIT      (1 << 1)  /* '-a' - Show information about all functions supported devices */
#define DDP_HELP_COMMAND_PARAMETER_BIT      (1 << 2)  /* '-h', '-?', '--help' - help command line parameter */
#define DDP_INTERFACE_COMMAND_PARAMETER_BIT (1 << 3)  /* '-i' - interface command line parameter */
#define DDP_XML_COMMAND_PARAMETER_BIT       (1 << 4)  /* '-x' - XML file command line parameter */
#define DDP_VERSION_COMMAND_PARAMETER_BIT   (1 << 5)  /* '-v' - version command line parameter */
#define DDP_SILENT_MODE_PARAMETER_BIT       (1 << 6)  /* '-l' - silent mode for scripts*/
#define DDP_JSON_COMMAND_PARAMETER_BIT      (1 << 7)  /* '-j' - JSON file command line parameter */

#define COMPARE_PCI_LOCATION(a, b) ((a)->location.segment) == ((b)->location.segment) ? \
                                    ((a)->location.bus) == ((b)->location.bus) ? TRUE : FALSE : FALSE

extern bool   Global_print_debug;

/* Function pointers for specific output actions */
void
free_memory(void* pointer);

bool
is_supported_device(adapter_t* adapter);

ddp_status_t
get_ddp_profile_list(adapter_t* adapter);

ddp_status_t
get_nvm_version(adapter_t* adapter);

ddp_status_t
get_firmware_version(adapter_t* adapter);

ddp_status_t
check_nvm_version(adapter_t* adapter, bool* is_fw_supported);

adapter_t*
get_adapter_from_list_node(node_t* node);

char*
get_error_message(ddp_status_value_t status);

#endif
